package it.eng.eremita.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

public class ImageUtils {
	
	
	public static BufferedImage resize(BufferedImage originale, int larghezza, int altezza) {
		
		BufferedImage piccola = new BufferedImage(larghezza,altezza,BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = piccola.createGraphics();
		g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
		
		g2.drawImage(originale,0,0,piccola.getWidth(),piccola.getHeight(),null);
		
		return piccola;
	}
	
	public static BufferedImage resizeConLimiti(BufferedImage originale, int larghezza, int altezza) {

		int largh = originale.getWidth();
		int alt = originale.getHeight();
		
		if (largh<=larghezza && alt<=altezza) return originale; //siamo dentro i limiti
		
		double rapportoLarghezza = 1.0 * largh / larghezza;
		double rapportoAltezza = 1.0 * alt /altezza;
		
		double rapporto = Math.max(rapportoLarghezza, rapportoAltezza);
		
		int newLarghezza = (int)Math.round(largh/rapporto);
		int newAltezza = (int)Math.round(alt/rapporto);
		
		return resize(originale,newLarghezza,newAltezza);
		
	}
	
	public static byte[] getBytes(BufferedImage image,String formato) {
		try {
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			ImageIO.write(image, formato, bos);
			return bos.toByteArray();
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public static BufferedImage getImage(byte[] bytes) {
		try {
			ByteArrayInputStream bos = new ByteArrayInputStream(bytes);
			return ImageIO.read(bos);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public static byte[] anteprima(byte[] immagine, int maxLarghezza, int maxAltezza) {
		return getBytes(resizeConLimiti(getImage(immagine),maxLarghezza,maxAltezza),"JPG");
	}
	
	
	public static String getMagicNumber(byte[] dati) {
		
		byte[] b = new byte[(dati.length>32?32:dati.length)];
		
		for (int k=0; k<b.length; k++) b[k]=dati[k];
		
		String hex = asHex(b);
		String upper = hex.toUpperCase();
		
		if(upper.startsWith("D0CF11E0A1B11AE1")) return "DOC"; //Tutti i file di tipo Microsoft Office
		else if(upper.startsWith("504B")) return "ZIP";
		else if(upper.startsWith("25504446")) return "PDF"; //File PDF
		else if(upper.startsWith("504B0304")) return "ODT"; //File ODT
		else if(upper.startsWith("FFD8")) return "JPG"; //File JPG
		else if(upper.startsWith("47494638")) return "GIF"; //File GIF
		else if(upper.startsWith("424D")) return "BMP"; //File BMP
		else if(upper.startsWith("89504E470D0A1A0A")) return "PNG"; //File PNG
		
		return null;
	}
	
	
	private static String asHex(byte buf[])
    {
            StringBuffer strbuf = new StringBuffer(buf.length * 2);

            for(int i=0; i< buf.length; i++)
            {
                    if(((int) buf[i] & 0xff) < 0x10)
                            strbuf.append("0");
                    strbuf.append(Long.toString((int) buf[i] & 0xff, 16));
            }
            return strbuf.toString();
    }

}
